<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('confirm_driver_payment', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(\App\Models\SummaryDriverPayment::class, 'summary_id')
                ->constrained('summary_driver_payment')
                ->onDelete('cascade');
            $table->foreignIdFor(\App\Models\User::class, 'driver_id')
                ->constrained('users')
                ->onDelete('cascade');
            $table->decimal('amount', 10, 2)->default(0);
            $table->string('currency', 3)->default('usd');
            $table->string('payment_method')->nullable(); // cash, bank, transfer, etc.
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('confirm_driver_payment');
    }
};
