<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('summary_driver_payment', function (Blueprint $table) {
            $table->id();
            $table->string('invoice_number')->nullable();
            $table->float('exchange_rate', 10, 2)->default(1.0);
            $table->decimal('total_amount_usd', 10, 2)->default(0.00);
            $table->decimal('total_amount_khr', 10, 2)->default(0.00);
            $table->decimal('driver_collect_usd', 10, 2)->default(0.00);
            $table->decimal('driver_collect_khr', 10, 2)->default(0.00);
            $table->integer('completed')->nullable()->default(0);
            $table->integer('assigned')->nullable()->default(0);
            $table->integer('canceled')->nullable()->default(0);

            $table->date('payment_date')->nullable();
            $table->foreignIdFor(\App\Models\User::class, 'driver_id')->constrained()->onDelete('cascade');
            $table->string('status')->default('pending'); // pending, paid, cancelled
            $table->text('note')->nullable();

            $table->foreignIdFor(\App\Models\User::class, 'created_by')->constrained('users')->onDelete('cascade');
            $table->foreignIdFor(\App\Models\User::class, 'updated_by')->nullable()->constrained('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('summary_driver_payment');
    }
};
