<?php

use Illuminate\Support\Facades\Http;

if (! function_exists('getExchangeRate')) {
    function getExchangeRate()
    {
        return cache()->remember('active_exchange_rate', 60, function () {
            $exchangeRate = \App\Models\ExchangeRate::Active()->first();

            return $exchangeRate ? $exchangeRate->rate : 4000;
        });
    }
}

if (! function_exists('sendTelegramNotification')) {
    function sendTelegramNotification(array $data)
    {
        $botToken = config('services.telegram.bot_token');
        // 107721483
        $chatId = $data['chat_id'] ?? '-4680961235';
        $trackingUrl = route('home.index').'?tracking='.$data['delivery_code'];

        $message = <<<TEXT
        ✅ <b>Delivery Completed #:</b> <code>{$data['delivery_code']}</code> 
        👤 <b>Customer:</b> <code>{$data['customer']}</code>
        🏪 <b>Paid To:</b> <code>{$data['payment']}</code>
        💰 <b>Amount:</b> <code>{$data['amount']} {$data['currency']}</code> | {$data['payment_method']}
        TEXT;

        return Http::post("https://api.telegram.org/bot{$botToken}/sendMessage", [
            'chat_id' => $chatId,
            'text' => $message,
            'parse_mode' => 'HTML',
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [
                        ['text' => '🔍 View Tracking | '.$data['delivery_code'], 'url' => $trackingUrl],
                    ],
                ],
            ]),
        ]);
    }
}

if (! function_exists('sendTelegramCancelNotification')) {
    function sendTelegramCancelNotification(array $data)
    {
        $botToken = config('services.telegram.bot_token');
        $chatId = $data['chat_id'] ?? '-4680961235';
        $trackingUrl = route('home.index').'?tracking='.$data['delivery_code'];

        $message = <<<TEXT
        ❌ <b>Delivery Canceled #:</b> <code>{$data['delivery_code']}</code>
        👤 <b>Customer:</b> <code>{$data['customer']}</code>
        📝 <b>Reason:</b> <code>{$data['reason']}</code>
        TEXT;

        return Http::post("https://api.telegram.org/bot{$botToken}/sendMessage", [
            'chat_id' => $chatId,
            'text' => $message,
            'parse_mode' => 'HTML',
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [
                        ['text' => '🔍 View Tracking | '.$data['delivery_code'], 'url' => $trackingUrl],
                    ],
                ],
            ]),
        ]);
    }
}

if (! function_exists('sendTelegramReportNotification')) {
    function sendTelegramReportNotification(array $data)
    {
        $botToken = config('services.telegram.bot_token');

        // 107721483
        $chatId = $data['chat_id'] ?? '-4680961235';
        $trackingUrl = route('shopCollectPayment.view.download', $data['invoice_number']);

        $message = <<<TEXT
        ✅ <b>Delivery Report #:</b> <code>{$data['invoice_number']}</code> 
         - <b>Customer:</b> <code>{$data['customer']}</code>
         - <b>Date:</b> <code>{$data['date']}</code>
         - <b>Total Package (New/Old):</b> <code> {$data['total_new_package']} / {$data['total_old_package']}</code>
         - <b>Success:</b> <code> {$data['completed']} </code>
         - <b>In Progress:</b> <code> {$data['assigned']} </code>
         - <b>Canceled:</b> <code> {$data['canceled']} </code>
         - <b>Return:</b> <code> {$data['return']} </code>
         - <b>In Stock:</b> <code> {$data['in_stock']}</code>
        🚛 <b>Delivery Fee #:</b> <code>{$data['service_fee']} USD</code> 
        💰 <b>Amount:</b> <code>{$data['total_amount_usd']} USD </code> | <code>{$data['total_amount_khr']} KHR</code> 
        TEXT;

        return Http::post("https://api.telegram.org/bot{$botToken}/sendMessage", [
            'chat_id' => $chatId,
            'text' => $message,
            'parse_mode' => 'HTML',
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [
                        ['text' => '🔍 View Report | '.$data['invoice_number'], 'url' => $trackingUrl],
                    ],
                ],
            ]),
        ]);
    }
}


if (! function_exists('sendTelegramBookPickUpNotification')) {
 

    function sendTelegramBookPickUpNotification(array $data)
    {
        $botToken = config('services.telegram.bot_token');
        $chatId = $data['chat_id'] ?? '-4680961235';

        // Caption for the notification
        $caption = "✅ Book PickUp # : <code>{$data['phone']} </code>\n"
                 . "Customer: <code>{$data['customer']} </code>\n"
                 . "<b>Total Package #:</b> <code>{$data['total_package']} </code>\n "
                 . "Booking Date: {$data['date']}\n"
                 . "🚛 <b>Remark #:</b> <code>{$data['remark']} </code>\n ";

        // Check for valid map URL
        $mapUrl = $data['map_url'] ?? null;
        if ($mapUrl) {
            $replyMarkup = json_encode([
                'inline_keyboard' => [
                    [
                        ['text' => '🔍 View Map', 'url' => $mapUrl],
                    ],
                ],
            ]);
        } else {
            $replyMarkup = null;
        }

        // Check if image exists
        $imageUrl = $data['images'] ?? null; // full URL or local path

        // If image exists and is local file, use Http::attach
        if ($imageUrl && file_exists($imageUrl)) {
            return Http::attach(
                'photo',
                file_get_contents($imageUrl),
                basename($imageUrl)
            )->withHeaders(['Accept' => 'application/json'])
            ->post("https://api.telegram.org/bot{$botToken}/sendPhoto", array_filter([
                'chat_id' => (string) $chatId,
                'caption' => (string) $caption,
                'parse_mode' => 'HTML',
                'reply_markup' => $replyMarkup,
            ]));
        }

        // If image URL is a remote URL (HTTP/S), send it directly
        if ($imageUrl && filter_var($imageUrl, FILTER_VALIDATE_URL)) {
            return Http::post("https://api.telegram.org/bot{$botToken}/sendPhoto", array_filter([
                'chat_id' => (string) $chatId,
                'photo' => $imageUrl,
                'caption' => (string) $caption,
                'parse_mode' => 'HTML',
                'reply_markup' => $replyMarkup,
            ]));
        }

        // Fallback: text-only message if no image
        return Http::post("https://api.telegram.org/bot{$botToken}/sendMessage", array_filter([
            'chat_id' => (string) $chatId,
            'text' => $caption,
            'parse_mode' => 'HTML',
            'reply_markup' => $replyMarkup,
        ]));
    }
}


if (! function_exists('sendTelegramPickUpNotification')) {
 

    function sendTelegramPickUpNotification(array $data)
    {
        $botToken = config('services.telegram.bot_token');
        $chatId = $data['chat_id'] ?? '-4680961235';

        // Caption for the notification
        $caption = "✅ PickUp Product # : <code>{$data['phone']} </code>\n"
                 . "Customer: <code>{$data['customer']} </code>\n"
                 . "<b>Total Package #:</b> <code>{$data['total_package']} </code>\n "
                 . "Booking Date: {$data['date']}\n"
                 . "🚛 <b>PickUp By #:</b> <code>{$data['pickup_by']} </code>\n ";

        // Check for valid map URL
        $mapUrl = $data['map_url'] ?? null;
        if ($mapUrl) {
            $replyMarkup = json_encode([
                'inline_keyboard' => [
                    [
                        ['text' => '🔍 View Map', 'url' => $mapUrl],
                    ],
                ],
            ]);
        } else {
            $replyMarkup = null;
        }

        // Check if image exists
        $imageUrl = $data['images'] ?? null; // full URL or local path

        // If image exists and is local file, use Http::attach
        if ($imageUrl && file_exists($imageUrl)) {
            return Http::attach(
                'photo',
                file_get_contents($imageUrl),
                basename($imageUrl)
            )->withHeaders(['Accept' => 'application/json'])
            ->post("https://api.telegram.org/bot{$botToken}/sendPhoto", array_filter([
                'chat_id' => (string) $chatId,
                'caption' => (string) $caption,
                'parse_mode' => 'HTML',
                'reply_markup' => $replyMarkup,
            ]));
        }

        // If image URL is a remote URL (HTTP/S), send it directly
        if ($imageUrl && filter_var($imageUrl, FILTER_VALIDATE_URL)) {
            return Http::post("https://api.telegram.org/bot{$botToken}/sendPhoto", array_filter([
                'chat_id' => (string) $chatId,
                'photo' => $imageUrl,
                'caption' => (string) $caption,
                'parse_mode' => 'HTML',
                'reply_markup' => $replyMarkup,
            ]));
        }

        // Fallback: text-only message if no image
        return Http::post("https://api.telegram.org/bot{$botToken}/sendMessage", array_filter([
            'chat_id' => (string) $chatId,
            'text' => $caption,
            'parse_mode' => 'HTML',
            'reply_markup' => $replyMarkup,
        ]));
    }
}
