<?php

namespace App\Models;

class Warehouse extends BaseLoggableModel
{
    protected $table = 'warehouses';

    protected $fillable = [
        'branch_id',
        'name',
        'status', // Default status is active
        'contact_name',
        'contact_phone',
        'city',
        'postal',
        'address',
    ];

    public function addresses()
    {
        return $this->hasMany(WarehouseAddress::class);
    }

    public function landAddress()
    {
        return $this->hasOne(WarehouseAddress::class)->where('import_type', 'land');
    }

    public function seaAddress()
    {
        return $this->hasOne(WarehouseAddress::class)->where('import_type', 'sea');
    }

    public function airAddress()
    {
        return $this->hasOne(WarehouseAddress::class)->where('import_type', 'air');
    }
}
