<?php

namespace App\Models;

class PaymentDelivery extends BaseLoggableModel
{
    protected $table = 'delivery_payments';

    protected $fillable = [
        'delivery_id',
        'payment_to',
        'amount',
        'payment_method',
        'note',
        'created_by',
    ];

    public function delivery()
    {
        return $this->belongsTo(Delivery::class);
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
