<?php

namespace App\Models;

class InTransitSummary extends BaseLoggableModel
{
    protected $table = 'in_transit_summary';

    protected $fillable = [
        'invoice_number',
        'truck_id',
        'from_warehouse_id',
        'to_warehouse_id',
        'date',
        'shipping_method',
        'status',
        'note',
        'service_fee',
        'created_by',
        'updated_by',
    ];

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    public function fromWarehouse()
    {
        return $this->belongsTo(Warehouse::class, 'from_warehouse_id');
    }

    public function toWarehouse()
    {
        return $this->belongsTo(Warehouse::class, 'to_warehouse_id');
    }

    public function truckBy()
    {
        return $this->belongsTo(User::class, 'truck_id');
    }

    public function deliveries()
    {
        return $this->hasMany(InTransit::class);
    }
}
