<?php

namespace App\Models;

class InTransit extends BaseLoggableModel
{
    protected $table = 'in_transit';

    protected $fillable = [
        'driver_id',
        'in_transit_summary_id',
        'delivery_id',
        'date',
        'date',
        'status',
        'created_by',
    ];

    public function driver()
    {
        return $this->belongsTo(User::class, 'driver_id');
    }

    public function delivery()
    {
        return $this->belongsTo(Delivery::class, 'delivery_id');
    }

    public function summary()
    {
        return $this->belongsTo(SummaryDriverPayment::class, 'summary_id');
    }
}
