<?php

namespace App\Models;

class DriverPayment extends BaseLoggableModel
{
    protected $table = 'driver_payment';

    protected $fillable = [
        'driver_id',
        'summary_id',
        'delivery_id',
        'payment_to',
        'amount',
        'currency',
        'payment_method',
        'payment_date',
        'status', // 'collected', 'reverted'
        'note',
        'created_by',
    ];

    public function driver()
    {
        return $this->belongsTo(User::class, 'driver_id');
    }

    public function delivery()
    {
        return $this->belongsTo(Delivery::class, 'delivery_id');
    }

    public function summary()
    {
        return $this->belongsTo(SummaryDriverPayment::class, 'summary_id');
    }
}
