<?php

namespace App\Models;

class Customer extends BaseLoggableModel
{
    protected $table = 'customers';

    protected $fillable = [
        'branch_id',
        'user_id',
        'customer_name',
        'phone',
        'address',
        'status',
        'type_of_customer',
        'mou_price',
        'currency',
        'telegram',
        'first_delivery_date',
        'last_delivery_date',
        'url_map',
        'latitude',
        'longitude',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function userlogin()
    {
        return $this->hasOne(User::class);
    }


    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function banks()
    {
        return $this->hasMany(CustomerBankQrCode::class);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }

    public function scopeInactive($query)
    {
        return $query->where('status', 'inactive');
    }

    public function deliveries()
    {
        return $this->hasMany(Delivery::class, 'customer_id');
    }
}
