<?php

namespace App\Models;

class ConfirmShopPayment extends BaseLoggableModel
{
    protected $table = 'confirm_shop_payment';

    protected $fillable = [
        'summary_shop_payment_id',
        'customer_id',
        'amount',
        'currency',
        'payment_method',
    ];

    public function summary()
    {
        return $this->belongsTo(SummaryShopPayment::class, 'summary_shop_payment_id');
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }
}
