<?php

namespace App\Models;

class BookPickUp extends BaseLoggableModel
{
    protected $table = 'book_pickup';

    protected $fillable = [
        'customer_id',
        'branch_id',
        'total_package',
        'status',
        'note',
        'status',
        'date',
        'pickup_by',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }

    public function images()
    {
        return $this->hasMany(BookPickupImage::class,'book_pickup_id');
    }

     public function pickupBy()
    {
        return $this->belongsTo(User::class, 'pickup_by');
    }

}
