<?php

namespace App\Http\Requests\Customers;

use Illuminate\Foundation\Http\FormRequest;

class BookPickupRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'customer_id'   => 'required|exists:customers,id',
            'total_package' => 'required|integer|min:1',

            'images'        => 'sometimes|array|max:4',
            'images.*'      => 'image|mimes:jpg,jpeg,png,webp|max:2048',

            'note'          => 'nullable|string',
        ];
    }

}
