<?php

namespace App\Http\Requests\Booking;

use Illuminate\Foundation\Http\FormRequest;

class TransitRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'truck_by' => 'required|exists:users,id',
            'delivery_ids' => 'required|array|min:1',
            'delivery_ids.*' => 'exists:delivery,id',
            'from_warehouse' => 'required',
            'to_warehouse' => 'required',
            'shipping_method' => 'required',
        ];
    }
}
