<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\App;

class SetApiLocale
{
    public function handle($request, Closure $next)
    {
        $lang =
            $request->query('lang') ??
            $request->header('Accept-Language') ??
            $request->user()?->locale ??
            config('app.locale');

        // Normalize: km-KH → km
        $lang = substr($lang, 0, 2);

        // Allow only supported languages
        if (! in_array($lang, ['en', 'km'])) {
            $lang = config('app.locale');
        }

        App::setLocale($lang);

        return $next($request);
    }
}
