<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Delivery;
use Illuminate\Http\Request;
use App\Traits\ApiResponse;

class SearchController extends Controller
{
    use ApiResponse;

   public function search(Request $request)
    {
        $request->validate([
            'search' => 'required|string',
        ]);

        $delivery = Delivery::select('id','code','receiver_address','receiver_phone','assigned_at','amount_usd','amount_khr','status')
        ->where(function ($q) use ($request) {
                $q->where('receiver_phone', $request->search)
                ->orWhere('code', $request->search)
                ->orWhere('tracking_number', $request->search)
                ->orWhere('local_tracking', $request->search);
            })
            ->latest()
            ->first();

        if (! $delivery) {
            return response()->json([
                'success' => false,
                'message' => 'Delivery not found.'
            ], 404);
        }

        return $this->successResponse($delivery, 'Delivery found.');
    }

}
