<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Login\LoginRequest;
use App\Traits\ApiResponse;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    use ApiResponse;

    /**
     * Login
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function login(LoginRequest $request)
    {

        $validate = $request->validated();

        $loginInput = $validate['login'];
        $password = $validate['password'];

        $fieldType = filter_var($loginInput, FILTER_VALIDATE_EMAIL) ? 'name' : 'phone';

        $credentials = [
            $fieldType => $loginInput,
            'password' => $password,
        ];

        if (! Auth::attempt($credentials)) {
            return $this->errorResponse('Invalid credentials', 'Authentication failed', 401);
        }

        $user = Auth::user();

        $token = $user->createToken('api-token')->plainTextToken;
        $role = $user->getRoleNames()->first();
        $data = [
            'token' => $token,
            'user' => $user->only(['id','display_name', 'avatar', 'email', 'phone']),
            'role' => $role,
            'branch'       => $user->defaultBranch ? [
                'id'   => $user->defaultBranch->id,
                'name' => $user->defaultBranch->name,
                'code' => $user->defaultBranch->code,
                'address' => $user->defaultBranch->address,
            ] : null,
        ];

        $this->logResponse($data, 'success response');

        return $this->successResponse($data, 'Login successful');
    }
}
