<?php

namespace App\Enums;

enum PaymentTo: string
{
    case DRIVER = 'driver';
    case SHOP = 'shop';
    case COMPANY = 'company';

    public function label(): string
    {
        return match ($this) {
            self::DRIVER =>  __('booking.driver'),
            self::SHOP =>  __('booking.shop'),
            self::COMPANY =>  __('booking.company'),
        };
    }
}
